/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.windowsansi;

import coursierapi.shaded.org.fusesource.jansi.internal.Kernel32;
import java.net.URL;
import java.util.Locale;
import java.util.Objects;

public final class WindowsAnsi {
    public static Size terminalSize() {
        long l = Kernel32.GetStdHandle(Kernel32.STD_OUTPUT_HANDLE);
        Kernel32.CONSOLE_SCREEN_BUFFER_INFO cONSOLE_SCREEN_BUFFER_INFO = new Kernel32.CONSOLE_SCREEN_BUFFER_INFO();
        Kernel32.GetConsoleScreenBufferInfo(l, cONSOLE_SCREEN_BUFFER_INFO);
        return Size.of(cONSOLE_SCREEN_BUFFER_INFO.windowWidth(), cONSOLE_SCREEN_BUFFER_INFO.windowHeight());
    }

    static {
        String string = System.getProperty("os.arch", "").toLowerCase(Locale.ROOT);
        if (string.equals("arm64") || string.equals("aarch64")) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            URL uRL = classLoader.getResource("coursierapi/shaded/org/fusesource/jansi/internal/native/Windows/arm64/jansi.dll");
            URL uRL2 = classLoader.getResource("coursierapi/shaded/org/fusesource/jansi/internal/native/Windows/arm64/libjansi.so");
            if (uRL == null && uRL2 != null) {
                System.setProperty("library.jansi.name", "libjansi.so");
            }
        }
        if (System.getProperty("com.ibm.vm.bitmode") == null) {
            System.setProperty("com.ibm.vm.bitmode", "64");
        }
    }

    public static final class Size {
        private final int width;
        private final int height;

        Size(int n, int n2) {
            this.width = n;
            this.height = n2;
        }

        public static Size of(int n, int n2) {
            return new Size(n, n2);
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidth() {
            return this.width;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Size size2 = (Size)object;
            return this.width == size2.width && this.height == size2.height;
        }

        public int hashCode() {
            return Objects.hash(this.width, this.height);
        }

        public String toString() {
            return "Size{width=" + this.width + ", height=" + this.height + '}';
        }
    }
}

